from django.conf import settings
from django_yauth.util import get_current_host, get_real_ip

from tvm2 import TVM2
from tvm2.protocol import BlackboxClientId


class TVM2Error(Exception):
    pass


def get_tvm_client():
    return TVM2(
        client_id=settings.TVM_CLIENT_ID,
        secret=settings.TVM_SECRET,
        blackbox_client=BlackboxClientId.ProdYateam,
        destinations=settings.TVM_DESTINATIONS,
    )


def get_service_ticket(client_id):
    client_id = str(client_id)
    return get_tvm_client().get_service_tickets(client_id).get(client_id)


def get_user_ticket(request):
    user_ticket = request.META.get(settings.YAUTH_TVM2_USER_HEADER)
    if user_ticket:
        return user_ticket

    tvm_client = get_tvm_client()
    session_id = request.COOKIES.get('Session_id')
    if not session_id:
        raise TVM2Error('Failed to get session_id from request')

    user_ticket = tvm_client.get_user_ticket(
        session_id=session_id,
        user_ip=get_real_ip(request),
        server_host=get_current_host(request),
    )
    if not user_ticket:
        raise TVM2Error('Failed to get TVM user ticket from blackbox')
    return user_ticket
