# coding: utf-8

import logging

from ids.registry import registry

from .conf import settings

logger = logging.getLogger(__name__)


formatter = registry.get_repository(
    'formatter', 'formatter', user_agent='procu', host=settings.WF_HOST
)


def wiki_format(text, timeout=None, config='extranet', safe=True):

    if not text:
        return ''
    try:
        return formatter.convert_to_html(
            wiki_text=text,
            version=settings.WF_VERSION,
            config=config,
            timeout=timeout or settings.WF_TIMEOUT,
        )

    except Exception as exc:
        logger.exception('Wiki text was not formatted.')
        if safe:
            return ''
        raise exc
