# coding: utf-8

from itertools import chain
from time import sleep

import django.apps
from django.conf import settings

from .fields import WFMixin, fmt_field


def fix_formatting():

    model_classes = django.apps.apps.get_models()

    counter = 0

    for model_class in model_classes:
        wf_fields = [
            field.name
            for field in model_class._meta.get_fields()
            if isinstance(field, WFMixin)
        ]

        if not wf_fields:
            continue

        for instance in model_class.objects.all():
            broken_fields = []

            for field in wf_fields:
                html = getattr(instance, fmt_field(field))
                if not (html is None or html):
                    broken_fields.append(field)

            if broken_fields:
                instance.save(
                    update_fields=list(
                        chain(broken_fields, map(fmt_field, broken_fields))
                    )
                )

                counter += 1
                sleep(settings.WF_BATCH_DELAY)

                if counter >= settings.WF_BATCH_SIZE:
                    return
