import os

from celery import Celery, signals
from django import db
from django.conf import settings


os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'intranet.pypi.src.settings')

app = Celery('pypi')

app.config_from_object('django.conf:settings')
app.autodiscover_tasks(lambda: settings.INSTALLED_APPS)

# Подчищаем протухшие соединения с базой перед каждой таской
signals.task_prerun.connect(db.close_old_connections)
