from django.core.management.base import BaseCommand
from django.db import connection


class Command(BaseCommand):

    help = 'MySQL to PostgreSQL'
    requires_model_validation = False

    def handle(self, *args, **options):
        c = connection.cursor()

        # timestamps
        c.execute(
            "SELECT table_name, column_name, data_type "
            "FROM INFORMATION_SCHEMA.COLUMNS WHERE data_type LIKE '%without%'"
        )
        for line in c.fetchall():
            c.execute(
                "ALTER TABLE %(table)s ALTER %(column)s "
                "TYPE timestamptz USING %(column)s AT TIME ZONE 'UTC';" % {
                    'table': line[0], 'column': line[1]
                }
            )

        # DEFERRABLE INITIALLY DEFERRED
        c.execute(
            "SELECT table_name, constraint_name FROM information_schema.table_constraints "
            "WHERE table_catalog='sentrydb' AND constraint_name LIKE '%_fkey' "
            "AND is_deferrable='NO' AND initially_deferred='NO'"
        )
        for table_name, constraint_name in c.fetchall():
            c.execute(
                "ALTER TABLE %(table)s ALTER CONSTRAINT %(constraint)s "
                "DEFERRABLE INITIALLY DEFERRED" % {
                    'table': table_name, 'constraint': constraint_name
                }
            )
