from celery.task import task

from intranet.pypi.src.ping.models import TouchMe
from intranet.pypi.src.utils.lock import lock_manager


@task(ignore_result=True)
def touch():
    """
    Пытается обновить timestamp у 1го объекта TouchMe в базе
    """
    with lock_manager.lock('ping', block=False) as acquired:
        if acquired:
            try:
                item = TouchMe.objects.get()
            except TouchMe.DoesNotExist:
                item = TouchMe()

            item.save()

        else:
            return 'locked'
