import logging
import time

from django.http import HttpResponse

from intranet.pypi.src.ping.models import TouchMe


logger = logging.getLogger('ping')


def ping_celery(request):
    """
    Ручка получения timestamp последнего обновления строки TouchMe в базе,
    который должна обновлять Celery.
    Т.о. проверяется и MySQL и Celery
    """
    unix_time = 'TouchMe object doesn\'t exists'

    try:
        touch_object = TouchMe.objects.get()
    except TouchMe.DoesNotExist:
        logger.error('no TouchMe object in database')
    else:
        modified_dt = touch_object.modified_at

        # get unix time from timestamp, and we don't need milliseconds
        unix_time = int(time.mktime(modified_dt.timetuple()))

    return HttpResponse(unix_time, content_type='text/plain')
