from datetime import date, timedelta

from django.conf import settings
from localshop.apps.packages.models import Release
from localshop.apps.packages.tasks import refresh_repository_mirrors

from intranet.pypi.src.celery_app import app
from intranet.pypi.src.utils.lock import lock_manager


@app.task
def update_packages():
    with lock_manager.lock('update_packages', block=False) as acquired:
        if acquired:
            refresh_repository_mirrors()

            Release.objects.filter(
                package__name__in=settings.ASSHAND_PACKAGE_NAMES,
                files=None,
            ).delete()
        else:
            return 'locked'


@app.task
def clean_packages():
    with lock_manager.lock('clean_packages', block=False) as acquired:
        if acquired:
            today = date.today()
            Release.objects.filter(
                package__name__in=settings.BLOATED_PACKAGE_NAMES,
                created__lt=(today - timedelta(days=settings.OUTDATED_PACKAGE_THRESHOLD))
            ).delete()
        else:
            return 'locked'
