from django.conf.urls import include, url
from django.views.decorators.cache import cache_page

from intranet.pypi.src import views


app_name = 'pypi'

urlpatterns = [
    url(
        r'^repo/(?P<repo>[-\._\w]+)/(?P<slug>[-\._\w\s]+)/?$',
        cache_page(60)(views.SimpleDetail.as_view()),
        name='simple_detail',
    ),
    url(r'^$', views.index, name='index'),
    url(r'^', include('localshop.urls')),
    url(r'^', include('intranet.pypi.src.ping.urls')),
    url(r'^', include('django_yauth.urls')),
]
