PY3_LIBRARY(pypi)

OWNER(g:tools-pypi)

PEERDIR(
    contrib/python/celery/py2
    contrib/python/django-appconf
    contrib/python/django-replicated
    contrib/python/django/django-1.11
    contrib/python/ipython
    contrib/python/kombu/py2
    contrib/python/localshop
    contrib/python/packaging
    contrib/python/psycopg2
    contrib/python/pymongo
    contrib/python/pytest
    contrib/python/pytz
    contrib/python/uwsgi

    library/python/blackbox
    library/python/django_mds
    library/python/django_pgaas
    library/python/django_template_common
    library/python/granular_settings
    library/python/python-django-yauth
    library/python/yenv
    library/python/ylock
    library/python/ylog
)

PY_SRCS(
    __init__.py
    backends.py
    celery_app.py
    manage.py
    middleware.py
    models.py
    settings.py
    tasks.py
    urls.py
    views.py
    management/__init__.py
    management/commands/__init__.py
    management/commands/mysql_to_pg.py
    ping/__init__.py
    ping/models.py
    ping/tasks.py
    ping/urls.py
    ping/views.py
    ping/management/__init__.py
    ping/management/commands/__init__.py
    ping/management/commands/ping.py
    ping/management/commands/ping_celery.py
    utils/__init__.py
    utils/lock.py
)

RESOURCE_FILES(
    PREFIX intranet/pypi/src/

    settings/000-debug.conf
    settings/000-debug.conf.unittest
    settings/001-site.conf
    settings/001-site.conf.testing
    settings/005-utils.conf
    settings/015-middlewares.conf
    settings/015-middlewares.conf.unittest
    settings/020-databases.conf
    settings/020-databases.conf.testing
    settings/020-databases.conf.unittest
    settings/030-security.conf
    settings/040-yauth.conf
    settings/050-mds.conf
    settings/050-mds.conf.testing
    settings/050-mds.conf.unittest
    settings/060-django.conf
    settings/060-django.conf.unittest
    settings/070-celery.conf
    settings/080-ylock.conf
    settings/090-logging.conf
    settings/100-packages.conf
)

NO_CHECK_IMPORTS()

END()
