PY3TEST()

OWNER(g:tools-pypi)

INCLUDE(${ARCADIA_ROOT}/antiadblock/postgres_local/recipe/recipe.inc)

ENV(PYTEST_ADDOPTS=-l)
ENV(DJANGO_SETTINGS_MODULE=intranet.pypi.src.settings)
ENV(YENV_TYPE=unittest)
ENV(YENV_NAME=intranet)

DATA(
    arcadia/intranet/pypi/tests/pypi_data/minibar.json
    arcadia/intranet/pypi/tests/pypi_data/pyramid_debugtoolbar.json
)

PEERDIR(
    intranet/pypi/src

    contrib/python/attrs
    contrib/python/django-webtest
    contrib/python/factory-boy
    contrib/python/mock
    contrib/python/packaging
    contrib/python/pytest-django
    contrib/python/pytest
    contrib/python/requests-mock
    contrib/python/requests-toolbelt
)

TEST_SRCS(
    __init__.py
    conftest.py
    factories.py
    utils.py

    apps/accounts/test_forms.py
    apps/dashboard/test_forms.py
    apps/packages/test_fetch_package_task.py
    apps/packages/test_models.py
    apps/packages/test_pypi.py
    apps/packages/test_tasks.py
    apps/packages/test_utils.py
    apps/packages/test_xmlrpc.py
    apps/packages/views/test_download_file.py
    apps/packages/views/test_simple_detail.py
    apps/packages/views/test_simple_index.py
    apps/permissions/test_models.py
    apps/permissions/test_utils.py
    management/__init__.py
    management/test_command_init.py
    management/test_runner.py
)

NO_CHECK_IMPORTS()

END()
