import os
import logging

from tools.releaser.src.cli.commands.workflow import release
from sandbox.projects.common.arcadia import sdk
from click import Context
from intranet.qooker.releaser_ci.proto import run_command_tasklet
from tasklet.services.yav.proto import yav_pb2 as yav
from tools.releaser.src.cli.utils import get_image_url


# Класс наследуется от сгенерированного run_command_tasklet.RunCommandBase
class RunCommandImpl(run_command_tasklet.RunCommandBase):

    def run(self):
        context = self.input.context

        logging.info('Running release')
        secret_uid = self.input.context.secret_uid
        spec = yav.YavSecretSpec(uuid=secret_uid, key='ci.token')
        token_value = self.ctx.yav.get_secret(spec).secret
        os.environ['RELEASER_OAUTH_TOKEN'] = token_value

        with sdk.mount_arc_path(
            'arcadia-arc:/#trunk',
            use_arc_instead_of_aapi=True,
            arc_oauth_token=os.getenv('RELEASER_OAUTH_TOKEN')
        ) as path:
            target = os.path.join(path, context.config_info.dir)
            logging.info(target)
            os.chdir(target)
            kwargs = {
                'image': get_image_url('qooker'),
                'deploy': True,
                'environment': 'tools-qooker-production',
                'components': 'backend:backend',
                'non_interactive': True,
                'buildfile': 'docker_package.json',
            }
            files = [f for f in os.listdir('.') if os.path.isfile(f)]

            logging.info(99999)
            logging.info(str(files))
            Context(release).invoke(release, **kwargs)

        # Выставляем выходные данные
        self.output.state.success = 1
