# coding: utf-8

import logging

from . import tracker
from .notify.email import send_emails
from ..config import get_config

logger = logging.getLogger(__name__)


def process_hook(hook_data):
    logger.info('{environmentId} {status}'.format(**hook_data))
    env = hook_data['environmentId']
    config = get_config(env)
    if config is None:
        logger.warn('No config for environment "%s"', env)
    else:
        if 'email' in config.notify and config.notify['email'].should_trigger(hook_data['status']):
            send_emails(
                config=config.notify['email'],
                hook_data=hook_data
            )
        if config.tracker and config.tracker.should_trigger(hook_data['status']):
            if config.tracker.transition is not None:
                tracker.transit_tickets(
                    transition_name=config.tracker.transition,
                    hook_data=hook_data,
                )
            if config.tracker.set_version.get('enabled', False):
                tracker.set_tickets_version(
                    hook_data=hook_data,
                    version_groups=config.tracker.set_version.get('version_groups'),
                    field_name=config.tracker.set_version.get('field_name'),
                )
            if config.tracker.update_description.get('enabled', False):
                tracker.update_tickets_description(
                    section_name=config.tracker.update_description['section_name'],
                    section_body=config.tracker.update_description['section_body'],
                    stand_link_constructor=config.tracker.update_description['stand_link_constructor'],
                    hook_data=hook_data,
                )
            if config.tracker.comment.get('enabled', False):
                tracker.comment_tickets(
                    hook_data=hook_data,
                    comment_text=config.tracker.comment['text'],
                    dont_repeat=config.tracker.comment.get('dont_repeat', False)
                )
