# coding: utf-8

import logging

from django.core.mail import EmailMessage

from ..utils import get_env_link_by_hook_data

logger = logging.getLogger(__name__)


def send_emails(config, hook_data):
    subject = config.subject_format.format(**hook_data)
    message = config.message_format.format(
        env_link=get_env_link_by_hook_data(hook_data),
        **hook_data
    )
    app, env = hook_data['environmentId'].rsplit('.', 1)
    if len(config.recipients):
        email = EmailMessage(
            subject,
            message,
            'qooker@yandex-team.ru',
            config.recipients,
            headers={
                'X-Qooker': 'yes',
                'X-Qooker-PlatformApplication': app,
                'X-Qooker-PlatformEnvironment': env,
            }
        )
        email.send(fail_silently=False)
        logger.info('Email sent to [%s]', ', '.join(config.recipients))
