import json
import logging

from django.http import HttpResponse
from django.views import View
from django_tools_log_context import request_context, request_profiler
from ylog.context import log_context

from .logic.main import process_hook

logger = logging.getLogger(__name__)


class PingView(View):
    def get(self, request):
        return HttpResponse()


class BaseView(View):
    def dispatch(self, request, *args, **kwargs):
        with request_context(request, endpoint=self), request_profiler(request, threshold=500):
            return super(BaseView, self).dispatch(request, *args, **kwargs)


class HookView(BaseView):
    def post(self, request):
        """
        Qloud при изменении статуса окружения присылает JSON следующего формата:

        {
            "environmentId": "prj.app.env",
            "version": 1503415523446,
            "status": "DEPLOYED",
            "statusChangeTs": 1503485012638,
            "installation": "qloud-ext",
            "comment": "any text"
        }
        """
        hook_data = json.loads(request.body)
        logger.info(f'hook_data: {hook_data}')
        with log_context(hook_data=hook_data):
            process_hook(hook_data)
        return HttpResponse()
