from nirvana.job_context import context
import psycopg2 as pg_driver

CONTEXT = context()
PARAMETERS = CONTEXT.get_parameters()


class FemidaQueryRunner(object):

    def __init__(self, **query_params):
        self.connection = pg_driver.connect(
            user=PARAMETERS['db_user'],
            password=PARAMETERS['db_password'],
            host=','.join(PARAMETERS['db_host'].split(' # ')),
            port=PARAMETERS['db_port'],
            database=PARAMETERS['db_name'],
        )
        self.sql_query = PARAMETERS['sql_query']
        self.columns = PARAMETERS['columns']
        self.query_params = query_params
        self.query_result = []

    def _format_query(self, **query_params):
        if query_params.keys().__len__() > 0:
            return self.sql_query.format(**query_params)
        else:
            return self.sql_query

    def _load_query_rows(self, cursor):
        raw_data_iterator = self._cursor_result_iterator(cursor)
        return [dict(zip(self.columns, row)) for row in raw_data_iterator]

    def _cursor_result_iterator(self, cursor, chunk_size=1000):
        while True:
            chunk = cursor.fetchmany(chunk_size)
            if not chunk:
                break
            for row in chunk:
                yield row

    def run(self):
        query = self._format_query(**self.query_params)
        cursor = self.connection.cursor()
        cursor.execute(query)
        self.query_result = self._load_query_rows(cursor)
        return self.query_result
