# coding: utf-8


from review.staff import views as staff_views
from review.frontend.views import reviews as frontend_reviews_views
from review.api import views as api_views

from review.lib.urls import url


urlpatterns = [
    url(r'^staff-structure-push/$', staff_views.StaffChangeView),

    url(r'^finance/$', api_views.FinanceView),
    url(r'^finance-raw/$', api_views.FinanceRawView),

    url(r'^loan/info/?$', api_views.LoanInfoView),
    url(r'^loan/requirements/?$', api_views.LoanRequirementsView),

    url(r'^bi-assignments/?$', api_views.PersonAssignmentView),
    url(r'^bi-assignments/(?P<login>[\w\-]+)/?$', api_views.PersonAssignmentView),
    url(r'^bi-assignments-list/?$', api_views.PersonAssignmentListView),
    url(r'^bi-income/?$', api_views.PersonIncomeView),
    url(r'^bi-income/(?P<login>[\w\-]+)/?$', api_views.PersonIncomeView),
    url(r'^bi-income-list/?$', api_views.PersonIncomeListView),

    url(r'^reviews/$', frontend_reviews_views.ReviewListView),
    url(r'^reviews/(?P<id>\d+)/stats/$', api_views.ReviewStatsView),
    url(r'^reviews/(?P<id>\d+)/remove-person-reviews/$', api_views.RemovePersonReviews),

    url(r'^person-reviews/$', api_views.PersonReviewsApiView),
]
