# coding: utf-8
from typing import Dict, List

import attr
from django import forms

from review.finance import (
    logic,
)
from review.lib import (
    errors,
    views,
)
from review.staff import models as staff_models


class LoanForm(forms.Form):
    person = forms.ModelChoiceField(
        queryset=staff_models.Person.objects.all(),
        to_field_name="login",
        required=True,
    )
    period = forms.IntegerField(required=False)


class LoanRequirementsView(views.View):
    form_cls_get = LoanForm

    def process_get(self, auth, data):
        person = data['person']
        answer = logic.get_loan_requirements(
            subject=auth.user,
            person=person,
            period=data.get('period'),
        )
        return answer.as_dict()


class LoanInfoView(views.View):

    def process_get(self, auth, data):
        return attr.asdict(
            logic.get_loan_info(subject=auth.user)
        )
