# coding: utf-8


from review.core.logic import assemble
from review.lib import views
from review.shortcuts import const


class ReviewStatsView(views.View):

    def process_get(self, auth, data):
        review_id = data['id']
        filters = {
            const.FILTERS.REVIEWS: [review_id]
        }
        requested_fields = [
            const.FIELDS.ID,
            const.FIELDS.STATUS,
            const.FIELDS.FLAGGED,
            const.FIELDS.FLAGGED_POSITIVE,
            const.FIELDS.MARK,
        ]
        review_roles = const.ROLE.PERSON_REVIEW_LIST_RELATED - {const.ROLE.PERSON.SELF}
        review_roles |= {const.ROLE.REVIEW.ADMIN, const.ROLE.GLOBAL.REVIEW_CREATOR}

        reviews = assemble.get_person_reviews(
            subject=auth.user,
            filters_chosen=filters,
            role_types=review_roles,
            fields_requested=requested_fields
        )

        reviews_by_status = {status: [] for status in const.PERSON_REVIEW_STATUS.ALL}

        for review in reviews:
            reviews_by_status[review.status].append(review)

        waiting_for_evaluation_total_count = len([
            pr for pr in reviews_by_status[const.PERSON_REVIEW_STATUS.WAIT_EVALUATION]
        ])
        waiting_for_approve_total_count = len(
            reviews_by_status[const.PERSON_REVIEW_STATUS.EVALUATION])
        waiting_for_announce_total_count = len(
            reviews_by_status[const.PERSON_REVIEW_STATUS.WAIT_ANNOUNCE])
        flagged_count = len([r for r in reviews if r.flagged or r.flagged_positive])

        return {
            'all': len(reviews),
            'waiting_for_evaluation_total': waiting_for_evaluation_total_count,
            'waiting_for_approve_total': waiting_for_approve_total_count,
            'waiting_for_announce_total': waiting_for_announce_total_count,
            'discuss': flagged_count,
        }
