# coding: utf-8
import jsonfield
from django.db import models


class BIPersonIncome(models.Model):

    person = models.OneToOneField(
        to='staff.Person',
        primary_key=True,
        related_name='bi_income',
    )
    data = models.TextField()
    hash = models.BigIntegerField(default=0)

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return self.person.login


class BIPersonDetailedIncome(models.Model):
    """Детализированные по месяцам данные дохода сотрудника. По записи на месяц."""
    unique = models.CharField(max_length=57, verbose_name='unique `login+month` key', primary_key=True)
    person = models.ForeignKey(
        to='staff.Person',
        related_name='bi_detailed_incomes',
        db_index=True,
    )
    data = models.TextField()
    hash = models.BigIntegerField(default=0)

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return f'DetailedIncome: {self.unique}'


class BIPersonAssignment(models.Model):

    person = models.ForeignKey(
        to='staff.Person',
        related_name='bi_assignments',
        related_query_name='bi_assignment',
        on_delete=models.CASCADE,
    )
    data = jsonfield.JSONField()
    hash = models.BigIntegerField(default=0)

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return '%s %s' % (self.id, self.person.login)


class BIPersonVesting(models.Model):

    person = models.OneToOneField(
        to='staff.Person',
        primary_key=True,
        related_name='bi_vesting',
    )
    data = models.TextField()
    hash = models.BigIntegerField(default=0)

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return self.person.login


class BICurrencyConversionRate(models.Model):
    id = models.CharField(primary_key=True, max_length=192)
    from_currency = models.CharField(max_length=16)
    to_currency = models.CharField(max_length=16)
    legal_entity_name = models.CharField(max_length=128)
    organization_id = models.IntegerField()
    conversion_date = models.DateField()
    rate = models.DecimalField(max_digits=19, decimal_places=10)
    legal_entity_convert_type = models.CharField(max_length=128)

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    class Meta:
        index_together = ('organization_id', 'conversion_date')

    def __str__(self):
        return self.id
