# coding: utf-8

import yenv

from review.lib import lock

from review.bi import controllers, testing_sync


@lock.get_lock_or_do_nothing_task
def sync_bi_income_data_task():
    if yenv.type == 'prestable':
        raise NotImplementedError('R/O database in prestable')

    if yenv.type == 'production':
        controllers.sync_bi_income_data()
    else:
        testing_sync.fill_income_with_mocks()


@lock.get_lock_or_do_nothing_task
def sync_bi_detailed_income_data_task():
    if yenv.type == 'prestable':
        raise NotImplementedError('R/O database in prestable')

    controllers.sync_bi_detailed_income_data()


@lock.get_lock_or_do_nothing_task
def sync_bi_assignment_data_task():
    controllers.sync_bi_assignment_data()


@lock.get_lock_or_do_nothing_task
def sync_bi_vesting_data_task():
    if yenv.type == 'prestable':
        raise NotImplementedError('R/O database in prestable')

    if yenv.type == 'production':
        controllers.sync_bi_vesting_data()
    else:
        testing_sync.fill_vesting_with_mocks()


@lock.get_lock_or_do_nothing_task
def sync_bi_rates_data_task():
    if yenv.type == 'prestable':
        raise NotImplementedError('R/O database in prestable')

    controllers.sync_bi_rates()
