from celery import Celery, Task, signals
from django import db
from django_tools_log_context.celery import CtxAwareMixin

from review import envconf


class ReviewTaskBase(CtxAwareMixin, Task):
    """
    Override default base task to enable extra log context for every task
    """
    pass


# set the default Django settings module for the 'celery' program.
envconf.configure()
app = Celery('review', task_cls=ReviewTaskBase)
app.config_from_object('django.conf:settings')

from django.conf import settings  # noqa: E402

app.conf.task_routes = settings.CELERY_TASK_ROUTES
app.autodiscover_tasks()

# Подчищаем протухшие соединения с базой перед каждой таской
signals.task_prerun.connect(db.close_old_connections)
