from functools import wraps

from django.http.request import HttpRequest
from review.compensations.actionlog import actionlog
from review.staff.models import Person


def retrieve_user(*args, **kwargs) -> Person or None:
    if not args:
        return None

    if hasattr(args[0], 'request'):
        return args[0].request.user

    for arg in args:
        if isinstance(arg, HttpRequest):
            return arg.user

    return None


def action_logged(action_name):
    def decorator(func):
        @wraps(func)
        def wrapper(*args, **kwargs):
            initiator = retrieve_user(*args)
            with actionlog.init(action_name, initiator):
                return func(*args, **kwargs)
        return wrapper
    return decorator
