from django.db import models

from review.compensations.models import choices


def actionlog_update_callback(sender, **kwargs):
    for instance in kwargs.get('queryset', []):
        actionlog_save_callback(sender, instance=instance, created=False)


def actionlog_bulk_create_callback(sender, **kwargs):
    for instance in kwargs.get('queryset', []):
        actionlog_save_callback(sender, instance=instance, created=True)


def add_object_to_log(sender, reason: choices.SNAPSHOT_REASONS, **kwargs):
    from review.compensations.actionlog import actionlog
    from review.compensations.models import LogRecord

    if not actionlog.is_initialized():
        return

    instance = kwargs.get('instance')
    if isinstance(instance, LogRecord):
        return

    actionlog.add_object(obj=instance, reason=reason)


def actionlog_delete_callback(sender, **kwargs):
    reason = choices.SNAPSHOT_REASONS.deletion
    add_object_to_log(sender, reason, **kwargs)


def actionlog_save_callback(sender, **kwargs):
    created = kwargs.get('created')
    reason = choices.SNAPSHOT_REASONS.nothing

    if created:
        reason = choices.SNAPSHOT_REASONS.addition
    elif created is False:
        reason = choices.SNAPSHOT_REASONS.change

    add_object_to_log(sender, reason, **kwargs)


def actionlog_m2m_changed_callback(sender, **kwargs):
    from review.compensations.actionlog.log import actionlog

    if not actionlog.is_initialized():
        return

    action = kwargs.get('action')
    instance = kwargs.get('instance')
    pk_set = kwargs.get('pk_set') or set()
    related_model = kwargs.get('model')

    reason = choices.SNAPSHOT_REASONS.addition if action == 'post_add' else choices.SNAPSHOT_REASONS.deletion

    instance_field_name = related_field_name = None
    for field in sender._meta.get_fields():
        if field.related_model is instance.__class__:
            instance_field_name = field.attname
        elif field.related_model is related_model:
            related_field_name = field.attname

    # В обработчике сигнала нет объектов скрытой модели. Их придется достать из базы
    if action in ('post_add', 'pre_remove'):
        objs = sender.objects.filter(**{
            related_field_name + '__in': pk_set,
            instance_field_name: instance.id,
        })
    elif action == 'pre_clear':
        objs = sender.objects.filter(**{
            instance_field_name: instance.id,
        })
    else:
        return

    for obj in objs:
        actionlog.add_object(obj=obj, reason=reason)
