from django.dispatch import Signal
from django.db import models
from review.compensations.actionlog import handlers


# Эти сигналы надо сендить явно!!!
post_update = Signal()
post_bulk_create = Signal()


models.signals.post_save.connect(handlers.actionlog_save_callback)
models.signals.post_delete.connect(handlers.actionlog_delete_callback)
models.signals.m2m_changed.connect(handlers.actionlog_m2m_changed_callback)

post_update.connect(handlers.actionlog_update_callback)
post_bulk_create.connect(handlers.actionlog_bulk_create_callback)
