from django.contrib import admin

from review.compensations import models
from review.compensations.models.payments import PersonPayment

from .base_entities import (
    CountryAdmin,
    PaymentPlanAdmin,
    RegularPaymentDateAdmin,
    PaymentTypeAdmin,
    ElementAdmin,
)
from .payments import (
    PersonPaymentScheduleAdmin,
    PersonPaymentAdmin,
    PaymentSchedulesFileAdmin,
    ExportPaymentsAdmin,
)
from .actionlog import SnapshotAdmin, LogRecordAdmin


admin.site.register(models.PaymentPlan, PaymentPlanAdmin)
admin.site.register(models.Country, CountryAdmin)
admin.site.register(models.RegularPaymentDate, RegularPaymentDateAdmin)
admin.site.register(models.PaymentType, PaymentTypeAdmin)
admin.site.register(models.Element, ElementAdmin)

admin.site.register(models.PersonPaymentSchedule, PersonPaymentScheduleAdmin)
admin.site.register(models.PersonPayment, PersonPaymentAdmin)
admin.site.register(models.PaymentSchedulesFile, PaymentSchedulesFileAdmin)
admin.site.register(models.ExportPayments, ExportPaymentsAdmin)

admin.site.register(models.Snapshot, SnapshotAdmin)
admin.site.register(models.LogRecord, LogRecordAdmin)
