from django.contrib import admin

from review.compensations import models


class SnapshotAdmin(admin.ModelAdmin):

    model = models.Snapshot

    list_display = ('id', 'obj_type', 'obj_id', 'obj_str', 'reason', 'log_record')
    readonly_fields = list_display + ('data', )
    list_filter = ('reason', 'obj_type')


class SnapshotInlineAdmin(admin.TabularInline):

    model = models.Snapshot
    readonly_fields = ('id', 'obj_type', 'obj_id', 'obj_id', 'reason', 'log_record', 'data')

    show_change_link = True
    show_full_result_count = True
    extra = 0
    can_delete = False


class LogRecordAdmin(admin.ModelAdmin):

    model = models.LogRecord

    list_display = ('action_name', 'action_time', 'user', )
    readonly_fields = ('user', )
    fields = ('action_name', 'action_time', 'user', 'context',)
    list_filter = ('action_name', )

    date_hierarchy = 'action_time'

    inlines = (SnapshotInlineAdmin, )
