from django.contrib import admin

from review.compensations import models


class PaymentPlanAdmin(admin.ModelAdmin):

    model = models.PaymentPlan

    list_display = ('slug', 'scheme', 'periods')
    fields = ('slug', 'scheme', 'periods')


class CountryAdmin(admin.ModelAdmin):

    model = models.Country

    list_display = ('code', 'name_ru', 'name_en')


class RegularPaymentDateAdmin(admin.ModelAdmin):

    model = models.RegularPaymentDate

    list_display = ('id', 'country', 'date', 'type')
    list_filter = ('type', 'country')
    ordering = ('date', )

    date_hierarchy = 'date'


class PaymentTypeAdmin(admin.ModelAdmin):

    list_display = ('name_ru', 'name_en', 'plan_id')

    model = models.PaymentType


class ElementAdmin(admin.ModelAdmin):

    list_display = ('name_ru', 'name_en', 'type', 'country', 'regular_payments')
    list_filter = ('country', 'type')

    model = models.Element
