from django import forms


class PersonPaymentScheduleForm(forms.Form):

    person_login = forms.CharField(max_length=50, required=True)
    full_name = forms.CharField(max_length=50, required=False)
    assignment = forms.CharField(max_length=16, required=False)

    bonus_absolute = forms.DecimalField(max_digits=20, decimal_places=2, required=True)
    bonus = forms.DecimalField(max_digits=7, decimal_places=2, required=False)

    salary = forms.DecimalField(max_digits=20, decimal_places=2, required=False)
    currency = forms.CharField(max_length=8, required=True)

    financial_reporting_center = forms.CharField(max_length=32, required=False)
    product = forms.CharField(max_length=32, required=False)
    gl_service = forms.CharField(max_length=32, required=False)
    legal_entity = forms.CharField(max_length=50, required=False)

    date_begin = forms.DateField(required=False)
    date_end = forms.DateField(required=False)

    status = forms.CharField(max_length=30, required=False)  # ?
    payments_start_date = forms.DateField()
    message = forms.CharField(max_length=200, required=False)  # ?
