# coding: utf-8

import base64
import json
import os

from Crypto.Cipher import AES
from Crypto import Random


SECRET_KEY = os.environ.get(
    'COMPENSATIONS_CRYPTOGRPHY_SECRET_KEY',
    'a' * 32
)
BLOCK_SIZE = 16


def pad(string):
    padding_length = BLOCK_SIZE - len(string) % BLOCK_SIZE
    padding_symbol = chr(padding_length)
    return string + padding_length * padding_symbol


def unpad(string):
    padding_symbol = string[-1]
    padding_length = ord(padding_symbol)
    return string[:-padding_length]


def encrypt(text, key=SECRET_KEY):
    init_vector = Random.new().read(BLOCK_SIZE)
    cipher = AES.new(key.encode("utf-8"), AES.MODE_CBC, init_vector)
    padded_text = pad(text).encode("utf-8")
    encrypted_padded_text = cipher.encrypt(padded_text)
    return base64.b64encode(init_vector + encrypted_padded_text).decode("utf-8")


def decrypt(encoded_string, key=SECRET_KEY):
    vector_with_text = base64.b64decode(encoded_string)
    init_vector, encrypted_text = (
        vector_with_text[:BLOCK_SIZE],
        vector_with_text[BLOCK_SIZE:]
    )
    cipher = AES.new(key.encode("utf8"), AES.MODE_CBC, init_vector)
    decrypted_text = cipher.decrypt(encrypted_text).decode("utf-8")
    return unpad(decrypted_text)
