# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2022-06-01 11:14
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import review.compensations.models
import review.lib.s3


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='PaymentPlan',
            fields=[
                ('slug', models.CharField(max_length=32, primary_key=True, serialize=False, unique=True, verbose_name='Слаг')),
                ('periods', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), default=list, size=12, verbose_name='Схема выплат по месяцам')),
                ('scheme', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), default=list, size=12, verbose_name='Схема выплат по процентам')),
            ],
            options={
                'verbose_name': 'План выплат',
                'verbose_name_plural': 'Виды выплат (справочник)',
            },
        ),
        migrations.CreateModel(
            name='PaymentSchedulesFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=128, verbose_name='Название выплаты')),
                ('file', models.FileField(blank=True, max_length=512, null=True, storage=review.lib.s3.S3Storage(), upload_to=review.compensations.models.payments._get_xlsx_filename, verbose_name='.xlsx-файл со значениями выплат сотрудникам')),
                ('payments_start_date', models.DateField(verbose_name='Дата отсчёта')),
                ('status', models.CharField(choices=[('pending', 'pending'), ('successed', 'successed'), ('failed', 'failed')], default='pending', max_length=32, verbose_name='Статус')),
                ('processed_at', models.DateTimeField(blank=True, default=None, null=True, verbose_name='Время последней обработки')),
                ('errors', models.TextField(blank=True, verbose_name='Ошибки валидации строк в файле')),
                ('plan', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='compensations.PaymentPlan', verbose_name='План выплат')),
                ('uploader', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='Автор файла')),
            ],
            options={
                'verbose_name': 'Файл выплат (Экселька)',
                'verbose_name_plural': '1. Файлы планов выплат',
            },
        ),
        migrations.CreateModel(
            name='PersonPayment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('payment_sum', models.DecimalField(decimal_places=2, max_digits=20, verbose_name='Сумма выплаты')),
                ('currency', models.CharField(choices=[('RUB', 'RUB'), ('USD', 'USD'), ('UAH', 'UAH'), ('EUR', 'EUR'), ('CHF', 'CHF'), ('CNY', 'CNY'), ('ILS', 'ILS'), ('CZK', 'CZK')], max_length=8, verbose_name='Валюта')),
                ('payment_date', models.DateField(verbose_name='Дата выплаты')),
                ('status', models.CharField(choices=[('scheduled', 'scheduled'), ('done', 'done'), ('cancelled', 'cancelled')], default='scheduled', max_length=16, verbose_name='Статус')),
            ],
            options={
                'verbose_name': 'Выплата',
                'verbose_name_plural': '3. Выплаты',
            },
        ),
        migrations.CreateModel(
            name='PersonPaymentSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('person_login', models.CharField(max_length=50, verbose_name='Логин')),
                ('full_name', models.CharField(max_length=50, verbose_name='ФИО')),
                ('assignment', models.CharField(default=None, max_length=16, null=True, verbose_name='Назначение')),
                ('bonus', models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=7, null=True, verbose_name='Премия (%)')),
                ('bonus_absolute', models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=20, null=True, verbose_name='Премия (абс)')),
                ('salary', models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=20, null=True, verbose_name='Зарплата')),
                ('currency', models.CharField(choices=[('RUB', 'RUB'), ('USD', 'USD'), ('UAH', 'UAH'), ('EUR', 'EUR'), ('CHF', 'CHF'), ('CNY', 'CNY'), ('ILS', 'ILS'), ('CZK', 'CZK')], max_length=8, verbose_name='Валюта')),
                ('payments_start_date', models.DateField(verbose_name='Дата отсчёта')),
                ('financial_reporting_center', models.CharField(blank=True, max_length=32, null=True, verbose_name='Центр финансовой отчётности')),
                ('product', models.CharField(blank=True, max_length=32, null=True, verbose_name='Продукт')),
                ('gl_service', models.CharField(blank=True, max_length=32, null=True, verbose_name='GL-сервис')),
                ('legal_entity', models.CharField(blank=True, max_length=120, null=True, verbose_name='Юр. лицо')),
                ('date_begin', models.DateField(blank=True, default=None, null=True, verbose_name='Дата с')),
                ('date_end', models.DateField(blank=True, default=None, null=True, verbose_name='Дата по')),
                ('status', models.CharField(max_length=16, verbose_name='Статус')),
                ('processed_at', models.DateTimeField(blank=True, default=None, null=True, verbose_name='Время последней обработки')),
                ('plan', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='compensations.PaymentPlan', verbose_name='План выплат')),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='compensations.PaymentSchedulesFile', verbose_name='Файл-источник')),
            ],
            options={
                'verbose_name': 'План по сотруднику',
                'verbose_name_plural': '2. Планы по сотрудникам',
            },
        ),
        migrations.AddField(
            model_name='personpayment',
            name='schedule',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='payments', to='compensations.PersonPaymentSchedule', verbose_name='План выплат'),
        ),
    ]
