# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2022-06-08 10:59
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import review.compensations.models
import review.lib.s3


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('compensations', '0002_periodic_payments'),
    ]

    operations = [
        migrations.CreateModel(
            name='ExportPayments',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='На какую дату')),
                ('file', models.FileField(blank=True, max_length=64, null=True, storage=review.lib.s3.S3Storage(), upload_to=review.compensations.models.payments._get_xlsx_filename, verbose_name='.xlsx-файл с выгрузкой')),
                ('status', models.CharField(choices=[('draft', 'draft'), ('ready', 'ready'), ('done', 'done'), ('cancelled', 'cancelled')], default='draft', max_length=10, verbose_name='Статус')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='Автор выгрузки')),
                ('payment_plan', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='compensations.PaymentPlan', verbose_name='Тип выплат')),
            ],
            options={
                'verbose_name': 'Выгрузка',
                'verbose_name_plural': '4. Выгрузки',
            },
        ),
        migrations.AddField(
            model_name='personpayment',
            name='message',
            field=models.CharField(default='', max_length=128, verbose_name='Сообщение'),
        ),
        migrations.AddField(
            model_name='personpaymentschedule',
            name='message',
            field=models.CharField(default='', max_length=128, verbose_name='Сообщение'),
        ),
        migrations.AlterField(
            model_name='paymentschedulesfile',
            name='payments_start_date',
            field=models.DateField(default=None, null=True, verbose_name='Дата отсчёта'),
        ),
        migrations.AlterField(
            model_name='regularpaymentdate',
            name='payment_type',
            field=models.CharField(choices=[('salary', 'salary'), ('prepayment', 'prepayment')], max_length=10),
        ),
        migrations.AddField(
            model_name='exportpayments',
            name='payments',
            field=models.ManyToManyField(related_name='exports', to='compensations.PersonPayment', verbose_name='Выплаты, попавшие в выгрузку'),
        ),
    ]
