# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2022-06-13 17:25
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import review.compensations.models.fields


class Migration(migrations.Migration):

    dependencies = [
        ('compensations', '0003_exportpayments'),
    ]

    operations = [
        migrations.CreateModel(
            name='Element',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_ru', models.CharField(max_length=50, verbose_name='Название')),
                ('name_en', models.CharField(max_length=50, verbose_name='Название англ.')),
                ('regular_payments', review.compensations.models.fields.ChoiceArrayField(base_field=models.CharField(choices=[('salary', 'salary'), ('advance', 'advance'), ('preadvance', 'preadvance')], max_length=10), blank=True, default=list, size=None, verbose_name='Привязка к регулярным платежам')),
                ('country', models.ForeignKey(db_column='country_code', on_delete=django.db.models.deletion.CASCADE, to='compensations.Country')),
            ],
            options={
                'verbose_name': 'Элемент',
                'verbose_name_plural': 'Элементы (справочник)',
            },
        ),
        migrations.CreateModel(
            name='PaymentType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_ru', models.CharField(max_length=50, unique=True, verbose_name='Название')),
                ('name_en', models.CharField(max_length=50, unique=True, verbose_name='Название англ.')),
            ],
            options={
                'verbose_name': 'Тип выплат',
                'verbose_name_plural': 'Типы выплат (справочник)',
            },
        ),
        migrations.AlterModelOptions(
            name='paymentplan',
            options={'verbose_name': 'График выплат', 'verbose_name_plural': 'Графики выплат (справочник)'},
        ),
        migrations.RenameField(
            model_name='personpayment',
            old_name='payment_sum',
            new_name='amount',
        ),
        migrations.RenameField(
            model_name='personpayment',
            old_name='actual_payment_date',
            new_name='date',
        ),
        migrations.RenameField(
            model_name='personpayment',
            old_name='payment_date',
            new_name='raw_date',
        ),
        migrations.RenameField(
            model_name='regularpaymentdate',
            old_name='payment_date',
            new_name='date',
        ),
        migrations.AddField(
            model_name='regularpaymentdate',
            name='type',
            field=models.CharField(blank=True, choices=[('salary', 'salary'), ('advance', 'advance'), ('preadvance', 'preadvance')], default=None, max_length=10, null=True, verbose_name='Тип выплат'),
        ),
        migrations.AlterField(
            model_name='regularpaymentdate',
            name='payment_type',
            field=models.CharField(choices=[('salary', 'salary'), ('advance', 'advance'), ('preadvance', 'preadvance')], default=None, max_length=10, null=True),
        ),
        migrations.AddField(
            model_name='paymenttype',
            name='plan',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='compensations.PaymentPlan', verbose_name='График выплат'),
        ),
        migrations.AddField(
            model_name='element',
            name='type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='compensations.PaymentType', verbose_name='Тип выплат'),
        ),
        migrations.AddField(
            model_name='exportpayments',
            name='payment_type',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='compensations.PaymentType', verbose_name='Тип выплат'),
        ),
        migrations.AddField(
            model_name='personpaymentschedule',
            name='element',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='compensations.Element', verbose_name='Элемент'),
        ),
    ]
