# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2022-06-21 13:21
from __future__ import unicode_literals

from django.db import migrations, models
import django_cryptography.fields


to_encrypt = [
    ('PersonPaymentSchedule', ['bonus', 'bonus_absolute', 'salary']),
    ('PersonPayment', ['amount']),
]


def forward_encrypt(apps, schema_editor):
    for model_name, fields in to_encrypt:
        model = apps.get_model("compensations", model_name)
        for row in model.objects.all():
            for field in fields:
                setattr(row, field, getattr(row, f'old_{field}'))
            row.save(update_fields=fields)


def backward_encrypt(apps, schema_editor):
    for model_name, fields in to_encrypt:
        model = apps.get_model("compensations", model_name)
        for row in model.objects.all():
            for field in fields:
                setattr(row, f'old_{field}', getattr(row, field))
            row.save(update_fields=fields)


class Migration(migrations.Migration):

    dependencies = [
        ('compensations', '0004_elements_paymenttypes'),
    ]

    operations = [
        migrations.RenameField(
            model_name='personpayment',
            old_name='amount',
            new_name='old_amount',
        ),
        migrations.RenameField(
            model_name='personpaymentschedule',
            old_name='bonus',
            new_name='old_bonus',
        ),
        migrations.RenameField(
            model_name='personpaymentschedule',
            old_name='bonus_absolute',
            new_name='old_bonus_absolute',
        ),
        migrations.RenameField(
            model_name='personpaymentschedule',
            old_name='salary',
            new_name='old_salary',
        ),
        migrations.AddField(
            model_name='personpayment',
            name='amount',
            field=django_cryptography.fields.encrypt(models.DecimalField(decimal_places=2, max_digits=20, verbose_name='Сумма выплаты', null=True)),
        ),
        migrations.AddField(
            model_name='personpaymentschedule',
            name='bonus',
            field=django_cryptography.fields.encrypt(models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=7, null=True, verbose_name='Премия (%)')),
        ),
        migrations.AddField(
            model_name='personpaymentschedule',
            name='bonus_absolute',
            field=django_cryptography.fields.encrypt(models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=20, null=True, verbose_name='Премия (абс)')),
        ),
        migrations.AddField(
            model_name='personpaymentschedule',
            name='salary',
            field=django_cryptography.fields.encrypt(models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=20, null=True, verbose_name='Зарплата')),
        ),
        migrations.RunPython(forward_encrypt, backward_encrypt),
        migrations.RemoveField(
            model_name='personpayment',
            name='old_amount',
        ),
        migrations.RemoveField(
            model_name='personpaymentschedule',
            name='old_bonus',
        ),
        migrations.RemoveField(
            model_name='personpaymentschedule',
            name='old_bonus_absolute',
        ),
        migrations.RemoveField(
            model_name='personpaymentschedule',
            name='old_salary',
        ),
    ]
