# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2022-07-24 13:16
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


def init_actionlog(apps, schema_editor):
    from review.compensations.actionlog.decorators import action_logged
    models = ('PaymentSchedulesFile', 'PersonPaymentSchedule', 'PersonPayment', 'ExportPayments')

    @action_logged('init__actionlog')
    def init_model_state(model):
        for instance in model.objects.all():
            instance.save()

    for model_name in models:
        model = apps.get_model('compensations', model_name)
        init_model_state(model)


def backward_init_actionlog(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
        ('compensations', '0009_add_PaymentType_and_PersonPaymentSchedule_fields'),
    ]

    operations = [
        migrations.CreateModel(
            name='LogRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action_name', models.CharField(db_index=True, max_length=127)),
                ('action_time', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('context', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Snapshot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reason', models.CharField(choices=[('nothing', 'nothing'), ('addition', 'addition'), ('change', 'change'), ('deletion', 'deletion')], max_length=10)),
                ('data', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('obj_id', models.IntegerField()),
                ('obj_str', models.CharField(max_length=127)),
                ('synced_to_yt', models.DateTimeField(default=None, null=True)),
                ('log_record', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='snapshots', to='compensations.LogRecord')),
                ('obj_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.ContentType')),
            ],
        ),
        migrations.AlterField(
            model_name='paymenttype',
            name='alert_layoff_before_payment',
            field=models.BooleanField(default=False, verbose_name='Уведомление в случае увольнения до выплаты'),
        ),
        migrations.AlterField(
            model_name='paymenttype',
            name='payment_postponing',
            field=models.BooleanField(default=False, verbose_name='Отсрочка выплат за длительные отсутствия'),
        ),
        migrations.AddIndex(
            model_name='snapshot',
            index=models.Index(fields=['obj_id', 'obj_type'], name='actionlog_snapshot_obj_index'),
        ),
        migrations.RunPython(init_actionlog, backward_init_actionlog),
    ]
