# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2022-07-25 12:02
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


def set_foreign_keys(apps, schema_editor):
    ExportPayments = apps.get_model('compensations', 'ExportPayments')

    for export in ExportPayments.objects.all():
        export.payments.update(export=export)


def set_m2m_relations(apps, schema_editor):
    ExportPayments = apps.get_model('compensations', 'ExportPayments')

    for export in ExportPayments.objects.all():
        for payment in export.person_payments.all():
            export.payments.add(payment)


class Migration(migrations.Migration):

    dependencies = [
        ('compensations', '0010_actionlog_init'),
    ]

    operations = [
        migrations.AddField(
            model_name='personpayment',
            name='export',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='person_payments', to='compensations.ExportPayments', verbose_name='Выгрузка, в которую попала выплата'),
        ),
        migrations.RunPython(set_foreign_keys, reverse_code=set_m2m_relations),
        migrations.RemoveField(model_name='exportpayments', name='payments'),
    ]
