import logging

from typing import List
from celery import shared_task

from review.compensations import logic, models


logger = logging.getLogger(__name__)


@shared_task()
def process_input_files(file_ids: List[int] = None):
    files_qs = (
        models.PaymentSchedulesFile.objects
        .filter(processed_at=None)
    )
    if file_ids:
        files_qs = files_qs.filter(id__in=file_ids)

    for payment_schedules_file in files_qs:
        try:
            logic.parse_compensation_plan_file_to_payment_schedules(payment_schedules_file)
        except Exception as ex:
            logger.error('Failed to process file %s', payment_schedules_file.id)


@shared_task()
def process_schedules(schedule_ids: List[int] = None):
    schedule_qs = (
        models.PersonPaymentSchedule.objects
        .filter(processed_at=None)
        .order_by('source')
    )
    if schedule_ids:
        schedules_qs = schedules_qs.filter(id__in=schedule_ids)

    for payment_schedule in schedule_qs:
        try:
            logic.generate_person_payments_from_schedule(payment_schedule)
        except Exception as ex:
            logger.error('Failed to process schedule %s', payment_schedule.id)
