from django.http import HttpRequest, HttpResponse, HttpResponseNotFound, HttpResponseForbidden

from review.compensations.models import PaymentSchedulesFile
from review.compensations.models.payments import ExportPayments


def payment_schedules_file(request: HttpRequest, file_id, *args, **kwargs):

    if not request.user.has_perm('compensations.add_paymentschedulesfile'):
        return HttpResponseForbidden()

    file_instance = PaymentSchedulesFile.objects.filter(id=file_id).first()
    if not file_instance:
        return HttpResponseNotFound(f'file with id {file_id} not found')

    file_content = file_instance.file.read()
    response = HttpResponse(
        content=file_content,
        content_type='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    )
    response['Content-Disposition'] = f'attachment; filename=inputfile_{file_id}.xlsx'
    return response


def export_payments_file(request: HttpRequest, export_id, *args, **kwargs):

    if not request.user.has_perm('compensations.change_exportpayments'):
        return HttpResponseForbidden()

    export_instance = ExportPayments.objects.filter(id=export_id).first()
    if not export_instance or export_instance.file is None:
        return HttpResponseNotFound(f'export with id {export_id} not found')

    file_content = export_instance.file.read()
    response = HttpResponse(
        content=file_content,
        content_type='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    )
    response['Content-Disposition'] = f'attachment; filename=exportfile_{export_id}.xlsx'
    return response
