from django.db.models import Q
from review.core import models as core_models


def get_all(subject, filters):
    calibration_person_review_filter_q = _prepare_calibration_person_review_filter_q(filters)
    calibration_person_reviews = (
        core_models.CalibrationPersonReview.objects
        .filter(
            calibration_person_review_filter_q,
            calibration__role__person=subject,
        )
        .values(
            'id',
            'person_review_id',
            'calibration_id',
            'discuss',
            'updated_at_auto',
        )
        # user can have multiple roles, so result can be duplicated
        .order_by('id')
        .distinct('id')
    )
    return calibration_person_reviews


def _prepare_calibration_person_review_filter_q(filters):
    ids = filters.get('ids')
    calibration_id = filters.get('calibration_id')
    discuss = filters.get('discuss')
    person_review_ids = filters.get('person_review_ids')
    calibration_status = filters.get('calibration_status')
    persons = filters.get('persons')

    query_params = {}

    if ids is not None:
        query_params['id__in'] = ids

    if person_review_ids:
        query_params['person_review_id__in'] = person_review_ids

    if calibration_id is not None:
        query_params['calibration_id'] = calibration_id

    if discuss is not None:
        query_params['discuss'] = discuss

    if calibration_status is not None:
        query_params['calibration__status__in'] = calibration_status

    if persons:
        query_params['person_review__person__login__in'] = persons

    return Q(**query_params)
