from collections import defaultdict

from review.core import (
    const,
    models,
)
from review.core.logic import domain_objs


def get_goodies(subject, review_ids, requested_fields=None):
    requested_fields = requested_fields or const.FIELDS.DEFAULT_GOODIE_FIELDS
    goodie_query = models.Goodie.objects.filter(
        review_id__in=review_ids,
    ).values(
        'review_id',
        *requested_fields
    )
    review_id_to_goods = defaultdict(list)
    for goodie in goodie_query:
        review_id = goodie.pop('review_id')
        goodie_obj = domain_objs.Goodie(**goodie)
        review_id_to_goods[review_id].append(goodie_obj)
    return review_id_to_goods
