from review.core.logic import assemble
from review.core import const
from review.lib.file_properties import XlsFileProperties
from review.shortcuts import serializers
from review.lib.serializers import XLSSerializer


def get_properties(review_id, template_type, user):
    properties = XlsFileProperties()
    properties.file_name = 'reviews'
    properties.sheet_name = 'reviews'

    properties.template = assemble.get_review_template_file(user, review_id, template_type)

    return properties


def get_serialized(data, user, review_id, fields, properties):
    data[const.FILTERS.REVIEWS] = [review_id]

    person_reviews = assemble.get_person_reviews(
        subject=user,
        fields_requested=set(fields),
        filters_chosen=data,
        role_types=const.ROLE.PERSON_REVIEW_LIST_RELATED | const.ROLE.CALIBRATION_PERSON_REVIEWS_ROLES_DEFAULT,
    )

    serialized_person_reviews = serializers.PersonReviewsSerializer.get_many_ordered(person_reviews)

    attachment_bytes = XLSSerializer.serialize(data=serialized_person_reviews, file_properties=properties)

    return attachment_bytes
