# coding: utf-8
from review.core import const


EXPORT_NEW_TO_OLD = {
    const.FIELDS.MARK: 'mark_at_review',
    # const.FIELDS.GOLDSTAR: ('extra_payment', 'extra_option'),
    const.FIELDS.SALARY_CHANGE: 'salary_change_percentage',
    const.FIELDS.LEVEL_CHANGE: 'grade_difference',
    const.FIELDS.BONUS: 'bonus_payment_percentage',
    const.FIELDS.BONUS_ABSOLUTE: 'bonus',
    const.FIELDS.SALARY_CHANGE_ABSOLUTE: 'salary_change_absolute',
    const.FIELDS.OPTIONS_RSU: 'bonus_option_value',
}

EXPORT_OLD_TO_NEW = {value: key for key, value in EXPORT_NEW_TO_OLD.items()}


def goldstar_old_to_new(extra_payment, extra_option):
    return {
        (False, False): const.GOLDSTAR.NO,
        (True, False): const.GOLDSTAR.BONUS_ONLY,
        (False, True): const.GOLDSTAR.OPTION_ONLY,
        (True, True): const.GOLDSTAR.OPTION_AND_BONUS,
    }[(extra_payment, extra_option)]


def goldstar_new_to_old(goldstar):
    extra_payment = goldstar in (
        const.GOLDSTAR.BONUS_ONLY,
        const.GOLDSTAR.OPTION_AND_BONUS
    )
    extra_option = goldstar in (
        const.GOLDSTAR.OPTION_ONLY,
        const.GOLDSTAR.OPTION_AND_BONUS,
    )
    return extra_payment, extra_option


def extra_payment_from_goldstar(goldstar):
    extra_payment, extra_option = goldstar_new_to_old(goldstar)
    return extra_payment


def extra_option_from_goldstar(goldstar):
    extra_payment, extra_option = goldstar_new_to_old(goldstar)
    return extra_option


def old_to_new_approve_level(old_review):
    approvers_count = old_review.approvers.max_approve_level()
    new_approve_level = approvers_count - old_review.approve_level
    if new_approve_level == approvers_count:
        # если старый approve_level == 0 — для нас это выход за границы массива
        new_approve_level = approvers_count - 1
    return new_approve_level
