# coding: utf-8
from review.core import const, models
from review.staff import logic as staff_logic


def is_calibration_admin(person):
    return models.CalibrationRole.objects.filter(
        type=const.ROLE.CALIBRATION.ADMIN,
        person=person,
    ).exclude(
        calibration__status=const.CALIBRATION_STATUS.ARCHIVE,
    ).exists()


class GLOBAL_ROLES(object):
    PERMS = {
        const.GLOBAL_ACTIONS.CREATE_REVIEW: (
            const.ROLE.GLOBAL.REVIEW_CREATOR,
        ),
        const.GLOBAL_ACTIONS.CREATE_CALIBRATION: (
            const.ROLE.GLOBAL.CALIBRATION_CREATOR,
        ),
        const.GLOBAL_ACTIONS.ADD_PERSON_REVIEWS_TO_CALIBRATION:
            is_calibration_admin,
    }


def get_global_actions(person):
    person = staff_logic.ensure_person_model(person)
    global_roles = models.GlobalRole.objects.filter(
        person=person
    ).values_list('type', flat=True)

    result = {}
    for perm, condition in GLOBAL_ROLES.PERMS.items():
        if callable(condition):
            value = condition(person)
        else:
            perm_roles = condition
            value = any(perm_role in global_roles for perm_role in perm_roles)
        result[perm] = const.OK if value else const.NO_ACCESS

    return result
