# coding: utf-8


from django.core.management.base import BaseCommand

from review.core import const
from review.core.logic.assemble import get_person_reviews
from review.core.logic.bulk import diffs
from review.core.models import PersonReview
from review.staff.models import Person


def fill_bonus():
    # robot can see everything
    robot = Person.objects.get(login='robot-review')
    person_reviews = get_person_reviews(
        robot,
        {const.FIELDS.BONUS, const.FIELDS.BONUS_ABSOLUTE, const.FIELDS.SALARY_CLOSEST_TO_REVIEW_START},
    )
    to_migrate = (
        pr for pr in person_reviews
        if pr.bonus and isinstance(pr.salary_closest_to_review_start, dict) and not pr.bonus_absolute
    )
    for pr in to_migrate:
        abs_bonus = diffs.percent_of_salary_to_absolute(pr, pr.bonus)
        PersonReview.objects.filter(id=pr.id).update(bonus_absolute=abs_bonus)


class Command(BaseCommand):

    def handle(self, *args, **options):
        fill_bonus()
