# coding: utf-8


import decimal
from itertools import zip_longest

from django.core.management.base import BaseCommand

from review.core import const
from review.core.logic.assemble import get_person_reviews
from review.core.logic.bulk import diffs
from review.core.models import PersonReview
from review.staff.models import Person


def fill_salary_change():
    # robot can see everything
    robot = Person.objects.get(login='robot-review')
    prids = PersonReview.objects.filter(salary_change_absolute=0).exclude(salary_change=0).values_list('id', flat=True)
    args = [iter(prids)] * 500
    nosalary = []
    for ids in zip_longest(*args, fillvalue=0):
        person_reviews = get_person_reviews(
            robot,
            {const.FIELDS.SALARY_CHANGE, const.FIELDS.SALARY_CHANGE_ABSOLUTE, const.FIELDS.SALARY_CLOSEST_TO_REVIEW_START},
            filters_chosen={const.FILTERS.IDS: ids}
        )
        to_migrate = (
            pr for pr in person_reviews
            if pr.salary_change and isinstance(pr.salary_closest_to_review_start, dict) and not pr.salary_change_absolute
        )
        for pr in to_migrate:
            salary = pr.salary_closest_to_review_start['value']
            if salary is None:
                nosalary.append(pr.id)
                continue
            salary = decimal.Decimal(salary)
            salary_change_absolute = diffs.percent_of_salary_to_absolute(salary, pr.salary_change)
            PersonReview.objects.filter(id=pr.id).update(salary_change_absolute=salary_change_absolute)
    return nosalary


class Command(BaseCommand):

    def handle(self, *args, **options):
        fill_salary_change()
