# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-08-10 15:39


from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Calibration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('status', models.CharField(choices=[('i', 'in_progress'), ('a', 'archive'), ('d', 'draft')], db_index=True, default='d', max_length=1)),
                ('start_date', models.DateField(db_index=True)),
                ('finish_date', models.DateField(db_index=True)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='CalibrationPersonReview',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('updated_at', models.DateTimeField(db_index=True)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
                ('calibration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='calibration_person_reviews', related_query_name='calibration_person_review', to='core.Calibration')),
            ],
        ),
        migrations.CreateModel(
            name='CalibrationRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('a', 'admin'), ('c', 'calibrator')], db_index=True, max_length=1)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
                ('calibration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', related_query_name='role', to='core.Calibration')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='calibration_roles', related_query_name='calibration_role', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='GlobalRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('c', 'calibration_creator'), ('r', 'review_creator'), ('s', 'support')], db_index=True, max_length=1)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='global_roles', related_query_name='global_role', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Goodie',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.SmallIntegerField(null=True)),
                ('mark', models.CharField(choices=[('A', 'A'), ('C', 'C'), ('B', 'B'), ('E', 'E'), ('D', 'D'), ('C-', 'C-'), ('-', '-'), ('B*', 'B*'), ('?', '?')], default='?', max_length=2)),
                ('goldstar', models.CharField(choices=[('a', 'option_and_bonus'), ('b', 'bonus_only'), ('-', 'no_goldstar'), ('o', 'option_only')], default='-', max_length=1)),
                ('level_change', models.SmallIntegerField(default=0)),
                ('salary_change', models.DecimalField(decimal_places=2, default=0, max_digits=7)),
                ('bonus', models.DecimalField(decimal_places=2, default=0, max_digits=7)),
                ('options_rsu', models.IntegerField(default=0)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PersonReview',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('a', 'approved'), ('e', 'evaluation'), ('d', 'announced'), ('w', 'wait_evaluation'), ('n', 'wait_announce')], db_index=True, default='w', max_length=1)),
                ('approve_level', models.IntegerField(default=0)),
                ('mark', models.CharField(choices=[('A', 'A'), ('C', 'C'), ('B', 'B'), ('E', 'E'), ('D', 'D'), ('C-', 'C-'), ('-', '-'), ('B*', 'B*'), ('?', '?')], default='?', max_length=2)),
                ('goldstar', models.CharField(choices=[('a', 'option_and_bonus'), ('b', 'bonus_only'), ('-', 'no_goldstar'), ('o', 'option_only')], default='-', max_length=1)),
                ('level_change', models.SmallIntegerField(default=0)),
                ('salary_change', models.DecimalField(decimal_places=2, default=0, max_digits=7)),
                ('bonus', models.DecimalField(decimal_places=2, default=0, max_digits=7)),
                ('options_rsu', models.IntegerField(default=0)),
                ('discuss', models.BooleanField(db_index=True, default=False)),
                ('updated_at', models.DateTimeField(db_index=True)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='person_reviews', related_query_name='person_review', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='PersonReviewRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('re', 'reader'), ('rv', 'reviewer'), ('ei', 'reader inherited'), ('cr', 'calibrator'), ('sr', 'superreader'), ('ci', 'calibrator inherited'), ('tr', 'top_reviewer'), ('si', 'superreader inherited'), ('ri', 'reviewer inherited')], db_index=True, max_length=2)),
                ('position', models.SmallIntegerField(default=0)),
                ('inheritance_depth', models.SmallIntegerField(default=0)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
                ('from_calibration_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='core.CalibrationRole')),
                ('inherited_from', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='core.PersonReviewRole')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='person_review_roles', related_query_name='person_review_role', to=settings.AUTH_USER_MODEL)),
                ('person_review', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', related_query_name='role', to='core.PersonReview')),
            ],
        ),
        migrations.CreateModel(
            name='Review',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('start_date', models.DateField(db_index=True)),
                ('finish_date', models.DateField(db_index=True)),
                ('finish_feedback_date', models.DateField(default=None, null=True)),
                ('finish_submission_date', models.DateField(default=None, null=True)),
                ('finish_calibration_date', models.DateField(default=None, null=True)),
                ('finish_approval_date', models.DateField(default=None, null=True)),
                ('achievements_since_date', models.DateField(default=None, null=True)),
                ('status', models.CharField(choices=[('i', 'in_progress'), ('a', 'archive'), ('d', 'draft'), ('f', 'frozen')], db_index=True, default='d', max_length=1)),
                ('mark_mode', models.CharField(choices=[('m', 'manual'), ('d', 'disabled')], default='d', max_length=1)),
                ('goldstar_mode', models.CharField(choices=[('c', 'chosen'), ('m', 'manual'), ('d', 'disabled')], default='d', max_length=1)),
                ('level_change_mode', models.CharField(choices=[('a', 'auto'), ('m', 'manual'), ('d', 'disabled')], default='d', max_length=1)),
                ('salary_change_mode', models.CharField(choices=[('a', 'auto'), ('m', 'manual'), ('d', 'disabled')], default='d', max_length=1)),
                ('bonus_mode', models.CharField(choices=[('a', 'auto'), ('m', 'manual'), ('d', 'disabled')], default='d', max_length=1)),
                ('options_rsu_mode', models.CharField(choices=[('a', 'auto'), ('m', 'manual'), ('d', 'disabled')], default='d', max_length=1)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='ReviewRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('a', 'review_admin'), ('s', 'superreviewer')], db_index=True, max_length=1)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='review_roles', related_query_name='review_role', to=settings.AUTH_USER_MODEL)),
                ('review', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', related_query_name='role', to='core.Review')),
            ],
        ),
        migrations.AlterIndexTogether(
            name='review',
            index_together=set([('id', 'status')]),
        ),
        migrations.AddField(
            model_name='personreview',
            name='review',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='person_reviews', related_query_name='person_review', to='core.Review'),
        ),
        migrations.AddField(
            model_name='goodie',
            name='review',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='goodies', to='core.Review'),
        ),
        migrations.AddField(
            model_name='calibrationpersonreview',
            name='person_review',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='calibration_person_reviews', related_query_name='calibration_person_review', to='core.PersonReview'),
        ),
        migrations.AlterUniqueTogether(
            name='reviewrole',
            unique_together=set([('person', 'review', 'type')]),
        ),
        migrations.AlterIndexTogether(
            name='reviewrole',
            index_together=set([('person', 'type')]),
        ),
        migrations.AlterUniqueTogether(
            name='personreviewrole',
            unique_together=set([('person', 'person_review', 'type', 'position', 'inherited_from')]),
        ),
        migrations.AlterIndexTogether(
            name='personreviewrole',
            index_together=set([('person', 'type')]),
        ),
        migrations.AlterUniqueTogether(
            name='personreview',
            unique_together=set([('person', 'review')]),
        ),
        migrations.AlterUniqueTogether(
            name='goodie',
            unique_together=set([('review', 'mark', 'goldstar')]),
        ),
        migrations.AlterUniqueTogether(
            name='calibrationrole',
            unique_together=set([('person', 'calibration', 'type')]),
        ),
        migrations.AlterIndexTogether(
            name='calibrationrole',
            index_together=set([('person', 'type')]),
        ),
        migrations.AlterUniqueTogether(
            name='calibrationpersonreview',
            unique_together=set([('calibration', 'person_review')]),
        ),
    ]
