# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-10-23 15:21


from django.db import migrations


def migrate_comments(apps, schema_editor):
    PersonReviewChange = apps.get_model('core', 'PersonReviewChange')
    PersonReviewComment = apps.get_model('core', 'PersonReviewComment')
    comments = []
    for change in PersonReviewChange.objects.all():
        if not change.comment:
            continue
        comments.append(PersonReviewComment(
            person_review_id=change.person_review_id,
            text_wiki=change.comment,
            subject_id=change.subject_id,
            created_at=change.created_at,
            updated_at=change.created_at,
        ))
    PersonReviewComment.objects.bulk_create(comments)


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0019_personreviewcomment'),
    ]

    operations = [
        migrations.RunPython(migrate_comments),
    ]
