# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-11-23 11:33


from django.db import migrations
from django.db import connection
from django.conf import settings


def migrate(apps, schema_editor):
    if settings.DATABASES['default']['ENGINE'] not in (
        'django_pgaas.backend',
        'django.db.backends.postgresql',
    ):
        return
    REVIEW_SEQUENCE_START_IN_NEW_SERVICE = 200
    PERSON_REVIEW_SEQUENCE_START_IN_NEW_SERVICE = 100000
    execute(
        """
            SELECT setval(
                pg_get_serial_sequence('"core_review"','id'),
                %s
            ) FROM "core_review";
        """ % REVIEW_SEQUENCE_START_IN_NEW_SERVICE
    )
    execute(
        """
            SELECT setval(
                pg_get_serial_sequence('"core_personreview"','id'),
                %s
            ) FROM "core_personreview";
        """ % PERSON_REVIEW_SEQUENCE_START_IN_NEW_SERVICE
    )


def backwards(apps, schema_editor):
    if settings.DATABASES['default']['ENGINE'] not in (
        'django_pgaas.backend',
        'django.db.backends.postgresql',
    ):
        return
    execute(
        """
            SELECT setval(
                pg_get_serial_sequence('"core_review"','id'),
                coalesce(max("id"), 1), max("id") IS NOT null
            ) FROM "core_review";
        """
    )
    execute(
        """
            SELECT setval(
                pg_get_serial_sequence('"core_personreview"','id'),
                coalesce(max("id"), 1), max("id") IS NOT null
            ) FROM "core_personreview";
        """
    )


def execute(query):
    with connection.cursor() as cursor:
        cursor.execute(query)


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0030_unmanaged_personreviewreader'),
    ]

    operations = [
        migrations.RunPython(
            code=migrate,
            reverse_code=backwards,
        ),
    ]
