# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-03-22 14:21


from django.db import migrations, models


def create_robot_role(apps, schema_editor):
    GlobalRole = apps.get_model('core', 'GlobalRole')
    Person = apps.get_model('staff', 'Person')
    for person in Person.objects.filter(login='robot-review'):
        GlobalRole(
            person=person,
            type='r',
        ).save()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0044_auto_20180319_1422'),
    ]

    operations = [
        migrations.AddField(
            model_name='personreviewchange',
            name='subject_type',
            field=models.CharField(choices=[('a', 'admin'), ('p', 'person')], db_index=True, default='p', max_length=10),
        ),
        migrations.AddField(
            model_name='personreviewcomment',
            name='subject_type',
            field=models.CharField(choices=[('a', 'admin'), ('p', 'person')], db_index=True, default='p', max_length=10),
        ),
        migrations.AlterField(
            model_name='globalrole',
            name='type',
            field=models.CharField(choices=[('e', 'exporter'), ('c', 'calibration_creator'), ('r', 'robot'), ('u', 'support')], db_index=True, max_length=1),
        ),
        migrations.RunPython(create_robot_role),
    ]
