# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-04-03 12:45


from django.db import (
    connection,
    migrations,
    models,
    utils,
)

from review.core.logic import review_actions


def announce_archived(apps, schema_editor):
    try:
        connection.cursor().execute('SET TRANSACTION ISOLATION LEVEL REPEATABLE READ')
    except utils.OperationalError:
        # sqlite has no SET TRANSACTION ISOLATION LEVEVL syntax
        pass
    reviews = apps.get_model('core', 'Review').objects.filter(
        ~models.Q(person_review__status='d'),
        status='a',
    )
    PersonReviewChange = apps.get_model('core', 'PersonReviewChange')
    changes_for_reviews = PersonReviewChange.objects.filter(
        person_review__review__in=reviews,
        notified=False,
    )
    to_exclude_changes = list(changes_for_reviews.values_list('id', flat=True))
    for r in reviews:
        review_actions.publish_review_results(r.id)
        changes_for_reviews.exclude(
            id__in=to_exclude_changes
        ).update(
            notified=True
        )


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0047_auto_20180403_1245'),
    ]

    operations = [
        migrations.RunPython(announce_archived),
    ]
